import sys
import shutil
import tempfile
from Bio import SeqIO

target, number = sys.argv[1:]
number = int(number)

header = """\
psLayout version 3

match	mis- 	rep. 	N's	Q gap	Q gap	T gap	T gap	strand	Q        	Q   	Q    	Q  	T        	T   	T    	T  	block	blockSizes 	qStarts	 tStarts
     	match	match	   	count	bases	count	bases	      	name     	size	start	end	name     	size	start	end	count
---------------------------------------------------------------------------------------------------------------------------------------------------------------
"""

filename = "%s.psl" % target

handle = open(filename)
line1 = next(handle)
line2 = next(handle)
line3 = next(handle)
line4 = next(handle)
line5 = next(handle)
assert line1 + line2 + line3 + line4 + line5 == header

names = []
for line in handle:
    words = line.split()
    assert len(words) == 21
    name = words[9]
    names.append(name)
handle.close()
names = set(names)

filename = "seqlist_%d.fa" % number
handle = open(filename)
output = tempfile.NamedTemporaryFile(delete=False, mode='wt')
records = SeqIO.parse(handle, 'fasta')
total = 0
removed = 0
for record in records:
    total += 1
    name = record.id
    if name in names:
        removed += 1
        continue
    output.write(format(record, 'fasta'))
handle.close()
output.close()
print("Removed %d out of %d lines" % (removed, total))

print("Overwriting %s" % filename)
shutil.move(output.name, filename)
print("Done")
